dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();

LManager:AddNewTable( 1, 4, 260, 230, "assets/images/table/castle", "assets/images/food/item_mark1", "B" );
LManager:AddNewTable( 2, 5, 240, 485, "assets/images/table/castle_6", "assets/images/food/item_mark2", "R" );
LManager:AddNewTable( 3, 2, 300, 360, "assets/images/table/castle_2", "assets/images/food/item_mark3", "R" );

numServers = 1;

useFloAsServer = 0;

useWineTable = 1;
numMoodBoosts = 3;
maxCoupleHappiness = 500;

--Level 5.8

--Group 1
guest = LManager.GenGuest(female01);
guest.likes={male02};
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = female01;
guest.percentRequestMusic = 100;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = male02;
guest.percentRequestDrink = 70;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(1, 4, 1000);

--Group 2
guest = LManager.GenGuest(male03);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = male01;
guest.percentRequestDrink = 50;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = female03;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(5, 7, 23000);

--Group 3
guest = LManager.GenGuest(aunt);
guest.matchType = female04;
guest.percentRequestTissue = 75;
LManager:AddGuest(guest);

guest = LManager.GenGuest(uncle);
guest.matchType = female04;
guest.percentRequestCoffee = 100;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = aunt;
guest.percentRequestDrink = 80;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(8, 10, 33000);


--Group 4
guest = LManager.GenGuest(male03);
guest.matchType = aunt;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = female03;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(11, 12, 60000);


-- Group 5


guest = LManager.GenGuest(male04);
guest.matchType = female04;
guest.likes={female01};
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = male04;
guest.percentRequestMusic = 100;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(13, 14, 90000);

--Group 6
guest = LManager.GenGuest(female01);
guest.matchType = male04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = female01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = male04;
guest.percentRequestMusic = 50;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(15, 17, 120000);

--Group 7
guest = LManager.GenGuest(female02);
guest.matchType = NOT_GUEST + male04;
guest.percentRequestMusic = 75;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = male01;
guest.percentRequestDrink = 40;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = male01;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(18, 21, 130000);

--Group 8
guest = LManager.GenGuest(female04);
guest.matchType = male01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(uncle);
guest.matchType = female04;
guest.percentRequestCoffee = 75;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = female04;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(22, 25, 150000);

--Group 9
guest = LManager.GenGuest(male02);
guest.matchType = table3;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = male02;
guest.percentRequestDrink = 100;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = table2;
guest.percentRequestMusic = 100;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = NOT_GUEST + male02;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(26, 29, 210000);

--Group 10
guest = LManager.GenGuest(male01);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = female03;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(30, 33, 260000);

--Group 11
guest = LManager.GenGuest(male03);
guest.matchType = male01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = NOT_GUEST + male02;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = male01;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(34, 37, 300000);


LManager:SetLevelSetting ("dogDelay", 75000); 
LManager:SetLevelSetting ("dogChance", 100);

LManager:AddQuinnEvent( "fx/fx_chef_table_fire.lua", 660, 155, 110000 );

LManager:SetLevelSetting ("cakeTipDelay", 150000);
LManager:SetLevelSetting ("cakeTipChance", 100);

LManager:AddReseatingRequestForGuest( 20000, female01 );
LManager:AddReseatingRequestForGuest( 55000, male03 );
LManager:AddReseatingRequestForGuest( 120000, male04 );
LManager:AddReseatingRequestForGuest( 200000, male01 );
LManager:AddReseatingRequestForGuest( 300000, female03 );
LManager:AddReseatingRequestForGuest( 350000, male03 );

LManager:AdjustGuestTolerance(150);

-- Set up the Level Settings
LManager:SetLevelNumber(5,8);
LManager:SetLevelScores(16000, 20000);
LManager:SetLevelTime(500000);
LManager:SetLevelSetting ("blaster", 1);

LManager:SetMusic("assets/audio/music/Big Band 4.ogg","assets/audio/music/new_dance_1.ogg","assets/audio/music/Uptempo 1.ogg");
LManager:SetBackgroundImage("assets/images/bg_castle");
LManager:SetChairImage("assets/images/table/chair05");

-- Generate Game Object
gameObject = LManager:GenerateGameObject();

-- Generate Level Settings
levelSetting = LManager:GenerateLevelSettings();

-- Generate Level Dialog
dofile( "scripts/LevelDialogGenerator.lua" );